<?php
/**
 * Aliases for Special:CategoryTree
 *
 * @file
 * @ingroup Extensions
 * @author Daniel Kinzler, brightbyte.de
 * @copyright © 2006-2008 Daniel Kinzler and others
 * @license GNU General Public Licence 2.0 or later
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'CategoryTree' => array( 'CategoryTree' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'CategoryTree' => array( 'KategorieBoom' ),
);

/** Aragonese (aragonés) */
$specialPageAliases['an'] = array(
	'CategoryTree' => array( 'Árbol_de_categorías' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'CategoryTree' => array( 'شجرة_تصنيف' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = array(
	'CategoryTree' => array( 'ܐܝܠܢܐ_ܕܣܕܪܐ' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'CategoryTree' => array( 'شجرة_تصنيف' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'CategoryTree' => array( 'শ্ৰেণীবৃক্ষ' ),
);

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = array(
	'CategoryTree' => array( 'Категория_ағасы' ),
);

/** Bikol Central (Bikol Central) */
$specialPageAliases['bcl'] = array(
	'CategoryTree' => array( 'KahoyNinKategorya' ),
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎) */
$specialPageAliases['be-tarask'] = array(
	'CategoryTree' => array( 'Дрэва_катэгорыяў' ),
);

/** Bulgarian (български) */
$specialPageAliases['bg'] = array(
	'CategoryTree' => array( 'Дърво_на_категориите' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'CategoryTree' => array( 'Puhun_tumbung' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'CategoryTree' => array( 'GwezennadurRummad' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'CategoryTree' => array( 'StabloKategorija' ),
);

/** Catalan (català) */
$specialPageAliases['ca'] = array(
	'CategoryTree' => array( 'Categories_en_arbre', 'Arbre_de_categories' ),
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = array(
	'CategoryTree' => array( '分類樹' ),
);

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = array(
	'CategoryTree' => array( 'Категорешан_дит' ),
);

/** Czech (čeština) */
$specialPageAliases['cs'] = array(
	'CategoryTree' => array( 'Strom_kategorií' ),
);

/** Danish (dansk) */
$specialPageAliases['da'] = array(
	'CategoryTree' => array( 'Kategoritræ' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'CategoryTree' => array( 'Kategorienbaum', 'Kategoriebaum' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'CategoryTree' => array( 'DaraKategoriya' ),
);

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'CategoryTree' => array( 'Bom_kategorijow' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'CategoryTree' => array( 'ΔέντροΚατηγορίας' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'CategoryTree' => array( 'Arbo_de_kategorioj', 'Kategorio-arbo' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'CategoryTree' => array( 'ÁrbolDeCategorías', 'Árbol_de_categorías' ),
);

/** Estonian (eesti) */
$specialPageAliases['et'] = array(
	'CategoryTree' => array( 'Kategooriapuu' ),
);

/** Basque (euskara) */
$specialPageAliases['eu'] = array(
	'CategoryTree' => array( 'KategoriaZuhaitza' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'CategoryTree' => array( 'درخت_رده' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'CategoryTree' => array( 'Luokkapuu' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'CategoryTree' => array( 'ArbreCatégorie', 'ArbreCategorie', 'Arbre_catégorie' ),
);

/** Franco-Provençal (arpetan) */
$specialPageAliases['frp'] = array(
	'CategoryTree' => array( 'Structura_d\'âbro_de_les_catègories', 'StructuraDÂbroDeLesCatègories' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'CategoryTree' => array( 'Árbore_de_categorías' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'CategoryTree' => array( 'Kategoriebaum' ),
);

/** Gujarati (ગુજરાતી) */
$specialPageAliases['gu'] = array(
	'CategoryTree' => array( 'શ્રેણીવૃક્ષ' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'CategoryTree' => array( 'עץ_קטגוריות' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'CategoryTree' => array( 'श्रेणी_वृक्ष', 'श्रेणीवृक्ष' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'CategoryTree' => array( 'Kategorijowy_štom' ),
);

/** 湘语 (湘语) */
$specialPageAliases['hsn'] = array(
	'CategoryTree' => array( '类别树' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'CategoryTree' => array( 'NivoKategori' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'CategoryTree' => array( 'Kategóriafa' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'CategoryTree' => array( 'Arbore_de_categorias' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'CategoryTree' => array( 'Pohon_kategori', 'PohonKategori' ),
);

/** Ido (Ido) */
$specialPageAliases['io'] = array(
	'CategoryTree' => array( 'KategorioArboro' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'CategoryTree' => array( 'AlberoCategorie' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'CategoryTree' => array( 'カテゴリツリー' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'CategoryTree' => array( 'კატეგორიის_ხე' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'CategoryTree' => array( 'មែកធាងចំណាត់ថ្នាក់ក្រុម' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'CategoryTree' => array( '분류트리' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'CategoryTree' => array( 'Saachjruppeboum' ),
);

/** Kurdish (Kurdî) */
$specialPageAliases['ku'] = array(
	'CategoryTree' => array( 'Dara_kategoriyan' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'CategoryTree' => array( 'GwedhenGlassys' ),
);

/** Latin (Latina) */
$specialPageAliases['la'] = array(
	'CategoryTree' => array( 'Categoriarum_arbor' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'CategoryTree' => array( 'Árvole_de_Kateggorías' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'CategoryTree' => array( 'Struktur_vun_de_Kategorien' ),
);

/** Malagasy (Malagasy) */
$specialPageAliases['mg'] = array(
	'CategoryTree' => array( 'Hazon-tsokajy' ),
);

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = array(
	'CategoryTree' => array( 'BatangKategori' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'CategoryTree' => array( 'ДрвоНаКатегории' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'CategoryTree' => array( 'വർഗ്ഗവൃക്ഷം' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'CategoryTree' => array( 'वर्गवृक्ष' ),
);

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = array(
	'CategoryTree' => array( 'Salasilah_kategori' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'CategoryTree' => array( 'SiġraKategorija' ),
);

/** Erzya (эрзянь) */
$specialPageAliases['myv'] = array(
	'CategoryTree' => array( 'КатегорияньЧувто' ),
);

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = array(
	'CategoryTree' => array( 'Kategoritre' ),
);

/** Low German (Plattdüütsch) */
$specialPageAliases['nds'] = array(
	'CategoryTree' => array( 'Kategorieboom' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'CategoryTree' => array( 'Kategorieboom' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'CategoryTree' => array( 'Categorieboom' ),
);

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = array(
	'CategoryTree' => array( 'Kategoritre' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'CategoryTree' => array( 'ArbreCategoria', 'Arbre_categoria' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'CategoryTree' => array( 'Drzewo_kategorii' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'CategoryTree' => array( 'د_وېشنيزو_ونه' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'CategoryTree' => array( 'Árvore_de_categorias' ),
);

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'CategoryTree' => array( 'Árvore_de_categorias', 'Árvore_de_categoria' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'CategoryTree' => array( 'Arborele_categoriilor' ),
);

/** Russian (русский) */
$specialPageAliases['ru'] = array(
	'CategoryTree' => array( 'Дерево_категорий' ),
);

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = array(
	'CategoryTree' => array( 'वर्गवृक्ष:' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'CategoryTree' => array( 'AlberoCategorie' ),
);

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = array(
	'CategoryTree' => array( 'ප්‍රවර්ගරුක' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'CategoryTree' => array( 'StromKategórií' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'CategoryTree' => array( 'Kategoriträd' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'CategoryTree' => array( 'SafuyaJamii' ),
);

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = array(
	'CategoryTree' => array( 'వర్గవృక్షం' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'CategoryTree' => array( 'หมวดหมู่แบบผังต้นไม้' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'CategoryTree' => array( 'Puno_ng_kaurian' ),
);

/** толышә зывон (толышә зывон) */
$specialPageAliases['tly'] = array(
	'CategoryTree' => array( 'Категоријон_до' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'CategoryTree' => array( 'KategoriAğacı', 'KategoriHiyerarşisi', 'UlamAğacı', 'UlamHiyerarşisi' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'CategoryTree' => array( 'Дерево_категорій' ),
);

/** Urdu (اردو) */
$specialPageAliases['ur'] = array(
	'CategoryTree' => array( 'شجرہ_زمرہ' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'CategoryTree' => array( 'ÀlbaroCategorie' ),
);

/** Veps (vepsän kel’) */
$specialPageAliases['vep'] = array(
	'CategoryTree' => array( 'KategorijoidenPu' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'CategoryTree' => array( 'Cây_thể_loại' ),
);

/** Yiddish (ייִדיש) */
$specialPageAliases['yi'] = array(
	'CategoryTree' => array( 'קאטעגאריע_בוים' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'CategoryTree' => array( '分类树' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'CategoryTree' => array( '分類樹' ),
);

/** Chinese (Taiwan) (中文（台灣）‎) */
$specialPageAliases['zh-tw'] = array(
	'CategoryTree' => array( '分類樹' ),
);